If (-NOT ([Security.Principal.WindowsPrincipal][Security.Principal.WindowsIdentity]::GetCurrent()).IsInRole([Security.Principal.WindowsBuiltInRole] "Administrator"))
{   
	$arguments = "& '" + $myinvocation.mycommand.definition + "'"

	Start-Process powershell -Verb runAs -ArgumentList $arguments
	Break
}

$scriptpath = $MyInvocation.MyCommand.Path
$dir = Split-Path $scriptpath

Write-Host "Unblocking all files in " $dir

cd $dir

Get-ChildItem -Recurse | Unblock-File
Write-Host "Done"
Pause 

